/*
 * Decompiled with CFR 0.152.
 */
package net.pasterdream.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.pasterdream.configuration.PasterdreamConfigClientConfiguration;
import net.pasterdream.init.PasterdreamModItems;

@Mod.EventBusSubscriber(modid="pasterdream", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvent {
    static String Tip = "";
    static final List<String> TIPS = Lists.newArrayList((Object[])new String[]{"\u9ed8\u8ba4\u6309[C]\u952e\u4f7f\u7528\u77ac\u8eab\u672f\uff01", "\u77ac\u8eab\u672f\u6709\u4e00\u6bb5\u6781\u77ed\u7684\u56de\u907f\u65e0\u654c\u5e27\uff0c\u5229\u7528\u597d\u5b83\uff01", "\u878d\u68a6\u80fd\u91cf\u6761\u548c\u7cbe\u795e\u503c\u6761\u7684\u4f4d\u7f6e\u53ef\u4ee5\u5728\u914d\u7f6e\u6587\u4ef6\u8c03\u6574\uff01", "\u539a\u7fc5\u7532\u866b\u4f1a\u540e\u7a7a\u7ffb\uff0c\u524d\u63d0\u662f\u4f60\u5f97\u7ed9\u5b83\u53d6\u4e2a\u7279\u522b\u7684\u540d\u5b57\uff01", "\u5e78\u8fd0\u503c\u662f\u771f\u5b9e\u6709\u7528\u7684\uff01", "\u6d77\u5cb8\u4f1a\u5237\u65b0\u4e00\u4e9b\u6e14\u6c11\u5c0f\u5c4b", "\u5728\u7279\u5b9a\u7684\u7fa4\u7cfb\u548c\u73af\u5883\u4e0b\uff0c\u53ef\u4ee5\u5728\u6d77\u6d0b\u91cc\u9493\u51fa\u6765\u4e00\u4e9b\u6df1\u6d77\u7684\u5b9d\u85cf\uff01", "\u9057\u8ff9\u53ef\u4e0d\u4f1a\u628a\u7bb1\u5b50\u6446\u5230\u7279\u522b\u660e\u663e\u7684\u4f4d\u7f6e...\u4f60\u5e94\u8be5\u4ed4\u7ec6\u5bfb\u627e\uff01", "\u6709\u4ec0\u4e48\u4e0d\u61c2\u7684\u5c31\u53bb\u67e5MC\u767e\u79d1\u5427\uff01", "\u6211\u4f1a\u4e00\u76f4\u66f4\u65b0\u8fd9\u4e2a\u6a21\u7ec4\uff01\u76f4\u5230...", "\u53cd\u9988\u6a21\u7ec4bug\u8bf7\u7ed9\u5f00\u53d1\u8005\u770b\u5d29\u6e83/\u6e38\u620f\u65e5\u5fd7\uff01", "\u62dc\u6258\u670b\u53cb\uff0c\u5f00\u5fc3\u8d77\u6765  \u4f60\u771f\u7684\u5f88\u68d2\uff01", "\u73cd\u60dc\u90a3\u4e9b\u7231\u4f60\u7684\u4eba\uff01", "\u53bb\u8bd5\u8bd5\u9b54\u6cd5\u91d1\u5c5e\u5427\uff01", "\u53bb\u8bd5\u8bd5\u6781\u5149\u5e7d\u5883\u5427\uff01", "\u54a9\u54a9\u72fc\u7684\u5c3e\u5df4\u6709\u591a\u957f\uff1f", "\u60f3\u6765\u4e00\u8d77\u5f00\u53d1\u5e15\u65af\u7279\u4e4b\u68a6\u5417\uff1f", "\u60f3\u4e0d\u60f3\u5728\u5e15\u65af\u7279\u91cc\u7559\u4e0b\u81ea\u5df1\u7684\u9057\u8ff9\u5efa\u7b51\u5462\uff1f\u6765\u8bd5\u8bd5\u770b\u5427\uff01", "\u7434\u96e8\u68a6\u662f\u6211\u7684\u8d5b\u535a\u4eb2\u5973\u513f\uff01", "\u7434\u96e8\u68a6\u6572\u53ef\u7231\uff01", "\u5e7c\u5e7c\u7d2b\u4e5f\u6572\u53ef\u7231\uff01", "\u751f\u65e5\u662f2002/11/28\uff01"});
    static final Set<Class<? extends Screen>> SCREENS = Sets.newHashSet((Object[])new Class[]{ConnectScreen.class, LevelLoadingScreen.class, ProgressScreen.class});

    @SubscribeEvent
    public static void clientSetupEvent(FMLClientSetupEvent event) {
        if (((Boolean)PasterdreamConfigClientConfiguration.LOADING_GUI_TIPS.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.addListener(ClientEvent::drawScreen);
        }
        event.enqueueWork(ClientEvent::work);
    }

    public static void drawScreen(ScreenEvent.Render.Post event) {
        ClientEvent.drawTip(event.getGuiGraphics(), event.getScreen());
    }

    private static void work() {
        ClientEvent.ItemPropertiesRegister();
    }

    private static void drawTip(GuiGraphics graphics, Screen screen) {
        if (!SCREENS.contains(screen.getClass())) {
            Tip = "";
            return;
        }
        if (Tip.isEmpty()) {
            Random random = new Random();
            Tip = TIPS.get(random.nextInt(TIPS.size()));
        }
        Font font = Minecraft.m_91087_().f_91062_;
        int height = screen.f_96544_ - 20;
        graphics.m_280488_(font, Tip, 10, height, Color.WHITE.getRGB());
        graphics.m_280488_(font, "PasterDream Tip:", 10, height - 10, Color.YELLOW.getRGB());
    }

    private static void ItemPropertiesRegister() {
        ItemProperties.register((Item)((Item)PasterdreamModItems.STAR_WISH_ROD.get()), (ResourceLocation)new ResourceLocation("pasterdream", "cast"), (itemStack, clientWorld, livingEntity, ic) -> {
            if (itemStack.m_41784_().m_128471_("cast")) {
                return 1.0f;
            }
            return 0.0f;
        });
    }
}

